//@line 40 "/c/builds/tbox-client/WINNT_5.2_Clobber/mozilla/browser/components/places/content/history-panel.js"

var gHistoryTree;
var gSearchBox;
var gHistoryGrouping = "";
var gSearching = false;

function HistorySidebarInit()
{
  gHistoryTree = document.getElementById("historyTree");
  gSearchBox = document.getElementById("search-box");

  gHistoryGrouping = document.getElementById("viewButton").
                              getAttribute("selectedsort");

  if (gHistoryGrouping == "site")
    document.getElementById("bysite").setAttribute("checked", "true");
  else if (gHistoryGrouping == "visited") 
    document.getElementById("byvisited").setAttribute("checked", "true");
  else if (gHistoryGrouping == "lastvisited")
    document.getElementById("bylastvisited").setAttribute("checked", "true");
  else if (gHistoryGrouping == "dayandsite")
    document.getElementById("bydayandsite").setAttribute("checked", "true");
  else
    document.getElementById("byday").setAttribute("checked", "true");

  initContextMenu();

  // XXXBlake we should persist the last search value
  // If it's empty, this will do the right thing and 
  // just group by the old grouping.
  // bug #359073 tracks this RFE
  // on timeout because of the corresponding setTimeout()
  // in the places tree binding's constructor
  setTimeout(function() { searchHistory(gSearchBox.value); }, 0); 
  gSearchBox.focus();
}

function initContextMenu() {
  // Force-hide items in the context menu which never apply to this view
  var alwaysHideElements = ["placesContext_new:folder",
                            "placesContext_new:separator",
                            "placesContext_cut",
                            "placesContext_paste",
                            "placesContext_sortby:name"];
  for (var i=0; i < alwaysHideElements.length; i++) {
    var elt = document.getElementById(alwaysHideElements[i]);
    elt.removeAttribute("selection");
    elt.removeAttribute("forcehideselection");
    elt.hidden = true;
  }

  // Insert "Bookmark This Link" right before the copy item
  document.getElementById("placesContext")
          .insertBefore(document.getElementById("addBookmarkContextItem"),
                        document.getElementById("placesContext_copy"));
}

function GroupBy(groupingType)
{
  gHistoryGrouping = groupingType;
  gSearchBox.value = "";
  searchHistory("");
}

function historyAddBookmarks()
{ 
  // no need to check gHistoryTree.view.selection.count
  // node will be null if there is a multiple selection 
  // or if the selected item is not a URI node
  var node = gHistoryTree.selectedURINode;
  if (!node) 
    return;
  
//@line 116 "/c/builds/tbox-client/WINNT_5.2_Clobber/mozilla/browser/components/places/content/history-panel.js"
  BookmarksUtils.addBookmark(node.uri, node.title, undefined);
//@line 118 "/c/builds/tbox-client/WINNT_5.2_Clobber/mozilla/browser/components/places/content/history-panel.js"
}

function SetSortingAndGrouping() {
  const NHQO = Ci.nsINavHistoryQueryOptions;
  var sortingMode;
  var groups = [];
  switch (gHistoryGrouping) {
    case "site":
      sortingMode = NHQO.SORT_BY_TITLE_ASCENDING;
      break; 
    case "visited":
      sortingMode = NHQO.SORT_BY_VISITCOUNT_DESCENDING;
      break; 
    case "lastvisited":
      sortingMode = NHQO.SORT_BY_DATE_DESCENDING;
      break; 
    case "dayandsite":
      groups.push(NHQO.GROUP_BY_DAY);
      groups.push(NHQO.GROUP_BY_HOST);
      sortingMode = NHQO.SORT_BY_TITLE_ASCENDING;
      break;
    default:
      groups.push(NHQO.GROUP_BY_DAY);
      sortingMode = NHQO.SORT_BY_TITLE_ASCENDING;
      break;
  }
  var options = asQuery(gHistoryTree.getResult().root).queryOptions;
  options.setGroupingMode(groups, groups.length);
  options.sortingMode = sortingMode;
}

function searchHistory(aInput)
{
  if (aInput) {
    if (!gSearching) {
      // Unset grouping when searching; applyFilter will update the view
      var options = asQuery(gHistoryTree.getResult().root).queryOptions;
      options.setGroupingMode([], 0);
      gSearching = true;
    }
  }
  else {
    // applyFilter will update the view
    SetSortingAndGrouping();
    gSearching = false;
  }

  gHistoryTree.applyFilter(aInput, false /* onlyBookmarks */, 
                           0 /* folderRestrict */, null); 
}

