//@line 40 "/c/builds/tbox-client2/WINNT_1.0.11_Depend/mozilla/browser/components/places/content/history-panel.js"

var gHistoryTree;
var gSearchBox;
var gHistoryGrouping = "";
var gSearching = false;

function HistorySidebarInit()
{
  gHistoryTree = document.getElementById("historyTree");
  gSearchBox = document.getElementById("search-box");

  gHistoryGrouping = document.getElementById("viewButton").
                              getAttribute("selectedsort");

  if (gHistoryGrouping == "site")
    document.getElementById("bysite").setAttribute("checked", "true");
  else if (gHistoryGrouping == "visited") 
    document.getElementById("byvisited").setAttribute("checked", "true");
  else if (gHistoryGrouping == "lastvisited")
    document.getElementById("bylastvisited").setAttribute("checked", "true");
  else if (gHistoryGrouping == "dayandsite")
    document.getElementById("bydayandsite").setAttribute("checked", "true");
  else
    document.getElementById("byday").setAttribute("checked", "true");

  initContextMenu();
  
  // set the place on the tree dynamically
  // otherwise, we will end up calling the place's tree's load() twice
  var optionsRef = {};
  var queriesRef = {};
  PlacesUtils.history.queryStringToQueries(ORGANIZER_ROOT_HISTORY_UNSORTED, queriesRef, {}, optionsRef);
  SetSortingAndGrouping(optionsRef.value);
  var place = PlacesUtils.history.queriesToQueryString(queriesRef.value, 1, optionsRef.value);
  gHistoryTree.place = place;

  gSearchBox.focus();
}

function initContextMenu() {
  // Force-hide items in the context menu which never apply to this view
  var alwaysHideElements = ["placesContext_new:folder",
                            "placesContext_new:separator",
                            "placesContext_cut",
                            "placesContext_paste",
                            "placesContext_sortBy:name"];
  for (var i=0; i < alwaysHideElements.length; i++) {
    var elt = document.getElementById(alwaysHideElements[i]);
    elt.removeAttribute("selection");
    elt.removeAttribute("forcehideselection");
    elt.hidden = true;
  }

  // Insert "Bookmark This Link" right before the copy item
  document.getElementById("placesContext")
          .insertBefore(document.getElementById("addBookmarkContextItem"),
                        document.getElementById("placesContext_copy"));
}

function GroupBy(groupingType)
{
  gHistoryGrouping = groupingType;
  gSearchBox.value = "";
  searchHistory("");
}

function historyAddBookmarks()
{ 
  // no need to check gHistoryTree.view.selection.count
  // node will be null if there is a multiple selection 
  // or if the selected item is not a URI node
  var node = gHistoryTree.selectedURINode;
  if (!node) 
    return;
  
//@line 116 "/c/builds/tbox-client2/WINNT_1.0.11_Depend/mozilla/browser/components/places/content/history-panel.js"
  PlacesUtils.showMinimalAddBookmarkUI(PlacesUtils._uri(node.uri), node.title);
//@line 120 "/c/builds/tbox-client2/WINNT_1.0.11_Depend/mozilla/browser/components/places/content/history-panel.js"
}

function SetSortingAndGrouping(aOptions) 
{
  const NHQO = Ci.nsINavHistoryQueryOptions;
  var sortingMode;
  var groups = [];
  switch (gHistoryGrouping) {
    case "site":
      sortingMode = NHQO.SORT_BY_TITLE_ASCENDING;
      break; 
    case "visited":
      sortingMode = NHQO.SORT_BY_VISITCOUNT_DESCENDING;
      break; 
    case "lastvisited":
      sortingMode = NHQO.SORT_BY_DATE_DESCENDING;
      break; 
    case "dayandsite":
      groups.push(NHQO.GROUP_BY_DAY);
      groups.push(NHQO.GROUP_BY_HOST);
      sortingMode = NHQO.SORT_BY_TITLE_ASCENDING;
      break;
    default:
      groups.push(NHQO.GROUP_BY_DAY);
      sortingMode = NHQO.SORT_BY_TITLE_ASCENDING;
      break;
  }
  aOptions.setGroupingMode(groups, groups.length);
  aOptions.sortingMode = sortingMode;
}

function searchHistory(aInput)
{
  if (aInput) {
    if (!gSearching) {
      // Unset grouping when searching; applyFilter will update the view
      var options = gHistoryTree.getResult().root.queryOptions;
      options.setGroupingMode([], 0);
      gSearching = true;
    }
  }
  else {
    // applyFilter will update the view
    var options = gHistoryTree.getResult().root.queryOptions;
    SetSortingAndGrouping(options);
    gSearching = false;
  }

  gHistoryTree.applyFilter(aInput, false /* onlyBookmarks */, 
                           0 /* folderRestrict */, null); 
}

