//@line 37 "/c/builds/tbox-client2/WINNT_1.0.11_Depend/mozilla/browser/base/content/pageinfo/feeds.js"

function initFeedTab()
{
  const feedTypes = {
    "application/rss+xml": gBundle.getString("feedRss"),
    "application/atom+xml": gBundle.getString("feedAtom")
  };

  // get the feeds
  var linkNodes = gDocument.getElementsByTagName("link");
  var length = linkNodes.length;
  for (var i = 0; i < length; i++) {
    if (linkNodes[i].rel == "alternate" &&
        linkNodes[i].type in feedTypes &&
        linkNodes[i].href) {
      addRow(linkNodes[i].title,
             feedTypes[linkNodes[i].type],
             linkNodes[i].href);
    }
  }

  var feedListbox = document.getElementById("feedListbox");
  if (feedListbox.getRowCount() > 0)
    document.getElementById("feedTab").hidden = false;
}

function onSubscribeFeed()
{
  var listbox = document.getElementById("feedListbox");
  openUILink(listbox.selectedItem.getAttribute("feedURL"),
             null, false, true, false, null);
}

function addRow(name, type, url)
{
  var item = document.createElement("richlistitem");
  item.setAttribute("feed", "true");
  item.setAttribute("name", name);
  item.setAttribute("type", type);
  item.setAttribute("feedURL", url);
  document.getElementById("feedListbox").appendChild(item);
}
